/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.NBTTags;
import noppes.npcs.NpcMiscInventory;
import noppes.npcs.containers.ContainerNPCBank;
import noppes.npcs.controllers.BankController;
import noppes.npcs.controllers.data.Bank;
import noppes.npcs.controllers.data.BankData;

public class PlayerBankData {
    public BankData lastBank;
    private String uuid;
    private int delay;

    public BankData get(int bankId) {
        if (this.lastBank != null && this.lastBank.bank.id == bankId) {
            return this.lastBank;
        }
        Bank bank = BankController.getInstance().getBank(bankId);
        if (bank == null) {
            return null;
        }
        if (bank.isPublic) {
            return bank.getBankData();
        }
        File dir = CustomNpcs.getWorldSaveDirectory("playerdata/" + this.uuid + "/banks");
        File file = new File(dir, bank.id + ".dat");
        this.lastBank = new BankData(bank, this.uuid);
        if (!file.exists()) {
            try {
                file.createNewFile();
                CompressedStreamTools.func_74799_a((NBTTagCompound)this.lastBank.getNBT(), (OutputStream)Files.newOutputStream(file.toPath(), new OpenOption[0]));
            }
            catch (Exception e) {
                LogWriter.error(e);
                this.lastBank = null;
                return null;
            }
        }
        try {
            this.lastBank.setNBT(CompressedStreamTools.func_74796_a((InputStream)Files.newInputStream(file.toPath(), new OpenOption[0])));
        }
        catch (IOException e) {
            LogWriter.error(e);
            this.lastBank = null;
            return null;
        }
        if (this.lastBank.cells.isEmpty()) {
            this.lastBank.clear();
        }
        return this.lastBank;
    }

    public void loadNBTData(NBTTagCompound compound, String uuid) {
        this.uuid = uuid;
        if (compound.func_150297_b("BankData", 9)) {
            File dir = CustomNpcs.getWorldSaveDirectory("playerdata/" + this.uuid + "/banks");
            NBTTagList list = compound.func_150295_c("BankData", 10);
            for (int bankPos = 0; bankPos < list.func_74745_c(); ++bankPos) {
                NBTTagCompound nbtCeils;
                int c;
                NBTTagCompound nbt = list.func_150305_b(bankPos);
                Bank bank = BankController.getInstance().getBank(nbt.func_74762_e("DataBankId"));
                if (bank == null) continue;
                BankData bd = new BankData(bank, this.uuid);
                int unlockedCeils = nbt.func_74762_e("unlockedCeils");
                HashMap<Integer, Boolean> upgradedSlots = NBTTags.getBooleanList(nbt.func_150295_c("UpdatedSlots", 10));
                for (int ceil = 0; ceil < nbt.func_150295_c("BankInv", 10).func_74745_c() && (c = (nbtCeils = nbt.func_150295_c("BankInv", 10).func_150305_b(ceil)).func_74762_e("Slot")) <= unlockedCeils; ++ceil) {
                    NpcMiscInventory inv = new NpcMiscInventory(upgradedSlots.get(c) != false ? 54 : 27);
                    inv.load(nbtCeils.func_74775_l("BankItems"));
                    bd.cells.put(c, inv);
                }
                File file = new File(dir, bank.id + ".dat");
                if (!file.exists()) {
                    try {
                        file.createNewFile();
                    }
                    catch (IOException e) {
                        LogWriter.error(e);
                    }
                }
                try {
                    CompressedStreamTools.func_74799_a((NBTTagCompound)bd.getNBT(), (OutputStream)Files.newOutputStream(file.toPath(), new OpenOption[0]));
                    continue;
                }
                catch (IOException e) {
                    LogWriter.error(e);
                }
            }
        }
    }

    public void remove(int bankId) {
        File dir = CustomNpcs.getWorldSaveDirectory("playerdata/" + this.uuid + "/banks");
        File file = new File(dir, bankId + ".dat");
        if (file.exists()) {
            file.delete();
        }
    }

    public void update(EntityPlayerMP player) {
        if (this.delay > 0) {
            --this.delay;
            if (this.delay == 0) {
                this.lastBank = null;
            }
        }
        if (this.lastBank == null) {
            return;
        }
        if (player.field_71070_bA instanceof ContainerNPCBank) {
            this.delay = 200;
        }
    }
}

